// ------------------------------------
//    OnBoardC Misc utility Library
//            Version 1.01
//    by: Harry Konstas May.19/2000
// ------------------------------------

#include "OBL.h"

// ------------------------------------ 
//          MISC UTILITIES
// ------------------------------------

int AppSwitch(char *fname)
{

  LocalID dbID;

  dbID=DmFindDatabase(0,fname);
  if(dbID==NULL) return 0;

  SysUIAppSwitch(0,dbID,sysAppLaunchCmdNormalLaunch,NULL);

  return 1;

}

char *StripLF(char *s)
{

  int i=0;

  while(s[i]) {
    if(s[i]==10||s[i]==13) {
      s[i]=0; break;
    }
    i++;
  }
}

void DelaySec(Word secs)
{
  SysTaskDelay(SysTicksPerSecond()*secs);
}

char *UpperCase(char *s)
{
  int i=0;

  while(s[i]) if(s[i++]>96) s[i-1]-=32;
  return s;
}

void ByteToHex(Byte v, char *buffer)
{
  char hex[16]= {48,49,50,51,52,53,54,55,
			   56,57,65,66,67,68,69,70 };
  Byte x;

  x=v&0xf;
  buffer[2]=0;
  buffer[1]=hex[x];
  x=v>>4;x=x&0xf;
  buffer[0]=hex[x];

}

UInt HexToI(char *hexstr)
{

  UInt v=0;
  char *p;

  if(StrLen(hexstr)>9) return 0;
  UpperCase(hexstr); p=hexstr;
  if(hexstr[1]=='X') p=p+2; // bypass 0x

  while(*p) {
    if(*p>'9') v=(v*16)+10+((*p++)-'A');
    else v=(v*16)+((*p++)-'0');
  }
  return v;
}

int IsAlpha(char c)
{

  if((c>47&&c<58)||
    (c>64&&c<91)||
    (c>96&&c<123)||c=='_')
    return true;

  return false;

}

int FindChar(char *s, char c)
{

  int i=0;

  do{
    if(s[i]==c) return i;
  }while(s[i++]);

  return -1;
}

void AddStr(char *d, char *s)
{
  int i,f=0;

  i=StrLen(d);
  while(s[f]) d[i++]=s[f++];
  d[i]=0;

}

char *RevStr(char *s)
{

  int i,d=0;
  char buffer[100];

  i=StrLen(s)-1; if(i>99) return 0;
  while(i!=-1) buffer[d++]=s[i--];
  buffer[d]=0;
  StrCopy(s,buffer);
  return buffer;

}


char *LongToA(long value, char *string)
{
    char *ptr;
    int flag = 0;

    if (value < 0) {
       if (value == -2147483648) 
         return StrCopy(string, "-2147483648");
       flag = '-';
       value = -value;
    }

    ptr = string;

    do {
      *(ptr++) = (char) (value  % 10 + 48);
    } while ((value /= 10) != 0);

    *ptr++ = (char) flag;
    *ptr = 0;
    return RevStr(string);

}

float AtoFloat(char *s)
{

  FlpCompDouble cf;
  float f;

  cf.fd=FlpAToF(s);
  f=cf.d;

  return f;

}

char *FloatToA(float f, char *buf)
{

/*
  FlpCompDouble cf;
  cf.d=f;
  FlpFToA(cf.fd,buf);
  return buf;
*/

  float f2;
  long v;
  char rbuf[20];

  if(f==0) {
    StrCopy(buf,"0.00");
    return buf;
  }

  v=(long)f;
  LongToA(v,buf);

  f2=(float)v;
  f2=(f-f2)*100;
  if(f2<0) f2=f2*-1;
  v=(long)f2;

  f2=f2-(float)v;
  if(f2>0.40) v++;

  LongToA(v,rbuf);
  AddStr(buf,".");
  if(v<10) AddStr(buf,"0");
  AddStr(buf,rbuf);

  return buf;

}

float AbsFloat(float x)
{
  if(x<0) x=x*-1;
  return x;
}

// ------------------------------------ 
//         ALERT/DEBUG FORMS
// ------------------------------------

void Output(Word FieldID, CharPtr message)
{

  FieldPtr fld;

  fld = GetObjectPtr(FieldID);
  FldInsert(fld,message,StrLen(message));
  FldDrawField(fld);

}

void DebugWin(CharPtr varname, long value)
{
  char buffer[16],buffer2[16];
  FrmCustomAlert(DebugAlert,varname,StrIToA(buffer,value),StrIToH(buffer2,value));
}

void ErrorBox(CharPtr msg,CharPtr cause)
{
  FrmCustomAlert(ErrorAlert,msg,cause,NULL);
}

void MsgBox(CharPtr msg1,CharPtr msg2)
{
  FrmCustomAlert(MsgAlert,msg1,msg2,NULL);
}

int AskBox(int AltForm,CharPtr msg)
{
  return FrmCustomAlert(AltForm,msg,NULL,NULL);
}

int UserAbort(void)
{
  int x,y,t;

  EvtGetPen(&x,&y,&t);
  if((t)&&y>160&&x<30) return 1;
 
  return 0;
}

void WaitTap(void)
{
  int x,y,t=0;

  while(!t) EvtGetPen(&x,&y,&t);

}


// ------------------------------------ 
//    FORM OBJECT CONTROL FUNCTIONS
// ------------------------------------

void HideControl(Word objID)
{
  FormPtr frm;
  Word i;

  frm = FrmGetActiveForm();
  i = FrmGetObjectIndex(frm,objID);
  FrmHideObject(frm,i);

}

void ShowControl(Word objID)
{

  FormPtr frm;
  Word i;

  frm = FrmGetActiveForm();
  i = FrmGetObjectIndex(frm,objID);
  FrmShowObject(frm,i);

}

void SetControlState(Word objID, int state)
{

  FormPtr frm;
  Word i;

  frm = FrmGetActiveForm();
  i=FrmGetObjectIndex(frm,objID);
  FrmSetControlValue(frm,i,state);

}

VoidPtr GetObjectPtr(Word objectID)
{
  FormPtr frm;
  frm = FrmGetActiveForm();
  return (FrmGetObjectPtr (frm, FrmGetObjectIndex(frm, objectID)));
}

FieldPtr SetFieldTextFromHandle (FieldPtr fldP, Handle txtH)
{
  Handle oldTxtH;

  oldTxtH=FldGetTextHandle (fldP);
  FldSetTextHandle (fldP, txtH);
  FldDrawField(fldP);
  if(oldTxtH) MemHandleFree (oldTxtH);
  return fldP;
}

FieldPtr SetFieldTextFromString (FieldPtr fldP, CharPtr strP)
{
  Handle txtH;

  txtH= MemHandleNew (StrLen (strP)+1);
  if(txtH==0) return NULL;
  StrCopy (MemHandleLock (txtH), strP);
  MemHandleUnlock (txtH);
  return SetFieldTextFromHandle (fldP, txtH);
}

static void SetTextToObject(Word objID, CharPtr text)
{
  FieldPtr fld;

  fld=GetObjectPtr(objID);
  SetFieldTextFromString(fld,text);
}

CharPtr GetTextFromObject(Word objID)
{
  FieldPtr fld;

  fld = GetObjectPtr(objID);
  return FldGetTextPtr(fld);
}

int GetSysString(Word strID, Word index, char *string)
{

  char *buf,tk[80];
  int i=0,c=0,d=0;

  buf = MemPtrNew(3000);

  SysStringByIndex(strID,1,buf,2990);

  while(buf[i])
  {
    if(buf[i]==0x0a) {
      if(c==index) break;
      c++;d=0;i++;
    }
    if(d>78) break;
    tk[d++]=buf[i++];
  }

  tk[d]=0;if(c!=index) {
    tk[0]=0;
    return 0;
  }

  StrCopy(string,tk);
  MemPtrFree(buf);
  return 1;
}

int DrawBitmap(UInt id, int x, int y)
{

  Handle resH;
  BitmapPtr bitmap;

  resH=DmGetResource(bitmapRsc,id);
  if(resH==NULL) return 0;

  bitmap=MemHandleLock(resH);  
  WinDrawBitmap(bitmap,x,y);
  DmReleaseResource(resH);
  MemHandleUnlock(resH);

  return 1;

}

int GetBitmapSize(UInt id, int *w, int *h)
{

  Handle resH;
  BitmapPtr bitmap;

  resH=DmGetResource(bitmapRsc,id);
  if(resH==NULL) return 0;

  bitmap=MemHandleLock(resH);  
  *w=bitmap->width;
  *h=bitmap->height;
  DmReleaseResource(resH);
  MemHandleUnlock(resH);

  return 1;

}

